unit UnitWap;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, AXmsCtrl_TLB;

type
  TFormWap = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ComboType: TComboBox;
    EditURL: TEdit;
    EditTitle: TEdit;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
  private
    objWapPush     : ISmsDataWapPush;
    objWapBookmark : ISmsDataWapBookmark;
  public
    strMessage     : String;
  end;

var
  FormWap: TFormWap;

implementation

{$R *.dfm}

{//////////////////////////////////////////////////////////////////////////////}

procedure TFormWap.FormCreate(Sender: TObject);
begin
  objWapPush        := TSmsDataWapPush.Create(Application).DefaultInterface;
  objWapBookmark    := TSmsDataWapBookmark.Create(Application).DefaultInterface;

  ComboType.Items.Add ( 'WAP Push' );
  ComboType.Items.Add ( 'WAP Bookmark' );

  ComboType.ItemIndex := 0;
end;

{//////////////////////////////////////////////////////////////////////////////}

procedure TFormWap.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

{//////////////////////////////////////////////////////////////////////////////}

procedure TFormWap.ButtonOKClick(Sender: TObject);
begin
  ModalResult := mrOK;

  if ComboType.ItemIndex = 0 then begin
    objWapPush.Description      := EditTitle.Text;
    objWapPush.URL              := EditURL.Text;

    objWapPush.Encode           ();

    strMessage                  := objWapPush.EncodedMessage;
  end;

  if ComboType.ItemIndex = 1 then begin
    objWapBookmark.Description  := EditTitle.Text;
    objWapBookmark.URL          := EditURL.Text;

    objWapBookmark.Encode       ();

    strMessage                  := objWapBookmark.EncodedMessage;
  end;
end;

{//////////////////////////////////////////////////////////////////////////////}

end.
